=begin
=娯楽/スロット




==更新履歴
  Date     Version Author Comment
==14/12/19 2.0.1   トリス 統合F～I I
==15/09/03 2.0.2   トリス 統合J～U J L O

=end

#==============================================================================
# ■ NWConst::Slot
#==============================================================================
module NWConst::Slot
  #
  PANELS = [
    [1, 3, 4, 0, 2, 0, 3, 3, 0, 1, 2, 0, 1, 4, 5, 1, 3, 4, 2, 2, 1, 0, 1, 0, 5, 0],
    [0, 5, 3, 2, 0, 0, 1, 0, 1, 1, 4, 3, 1, 4, 1, 0, 0, 2, 4, 0, 3, 1, 2, 2, 5, 3],
    [1, 4, 0, 3, 0, 1, 4, 2, 2, 0, 3, 1, 1, 0, 5, 3, 0, 4, 0, 1, 0, 2, 2, 3, 5, 1],
  ]
  
  # 
  LINES = [[1, 1, 1], [0, 0, 0], [2, 2, 2], [0, 1, 2], [2, 1, 0]]
  # 役
  BONUS = {
    [-1, -1, -1] => {
      :desc  => "Nothing matched.",
      :scale => 0,
      :sound => NWConst::Casino::SE_LOSE,
      :skill_id => 3270,
      :medal => nil,
    },  
    [0, -1, -1] => {
      :desc  => "1 Cherry!",
      :scale => 1,
      :sound => NWConst::Casino::SE_WIN1,
      :skill_id => 3270,
      :medal => nil,
    },  
    [0, 0, -1] => {
      :desc  => "2 Cherry!",
      :scale => 2,
      :sound => NWConst::Casino::SE_WIN1,
      :skill_id => 3270,
      :medal => nil,
    },  
    [0, 0, 0] => {
      :desc  => "3 Cherry!",
      :scale => 5,
      :sound => NWConst::Casino::SE_WIN1,
      :skill_id => 3271,
      :medal => nil,
    },
    [1, 1, 1] => {
      :desc  => "Plum!",
      :scale => 20,
      :sound => NWConst::Casino::SE_WIN2,
      :skill_id => 3272,
      :medal => nil,
    },
    [2, 2, 2] => {
      :desc  => "Bell!",
      :scale => 50,
      :sound => NWConst::Casino::SE_WIN2,
      :skill_id => 3273,
      :medal => nil,
    },
    [3, 3, 3] => {
      :desc  => "Watermelon!",
      :scale => 100,
      :sound => NWConst::Casino::SE_WIN3,
      :skill_id => 3274,
      :medal => nil,
    },
    [4, 4, 4] => {
      :desc  => "BAR!",
      :scale => 200,
      :sound => NWConst::Casino::SE_WIN3,
      :skill_id => 3275,
      :medal => nil,
    },
    [5, 5, 5] => {
      :desc  => "777!",
      :scale => 500,
      :sound => NWConst::Casino::SE_WIN4,
      :skill_id => 3276,
      :medal => NWConst::Casino::MEDAL_SLOT,
    },
  } 
  # リールオフセット
  REEL_OFFSET = {:x => 64, :y => 128}
  # リールランプオフセット
  REEL_LAMP_OFFSET = [
    {:x =>  64, :y => 320},
    {:x => 128, :y => 320},
    {:x => 192, :y => 320},  
  ]
  # ライン番号オフセット
  LINE_NUMBER_OFFSET = [
    {:x => 0, :y => 192},
    {:x => 0, :y => 128},
    {:x => 0, :y => 256},
    {:x => 0, :y => 64},
    {:x => 0, :y => 320},
  ]
  # 効果音
  START_SE = RPG::SE.new("open2")
  STOP_SE  = RPG::SE.new("Blow1")
end

#==============================================================================
# ■ Reel
#==============================================================================
class Reel
  #--------------------------------------------------------------------------
  # ● 公開インスタンス変数
  #--------------------------------------------------------------------------
  attr_reader   :index
  attr_reader   :oy
  attr_reader   :panels
  #--------------------------------------------------------------------------
  # ● オブジェクト初期化
  #--------------------------------------------------------------------------
  def initialize(index, slot)
    @index = index
    @slot  = slot
  end
  #--------------------------------------------------------------------------
  # ● クリア
  #--------------------------------------------------------------------------
  def clear
    init_panels
    init_chance
    @oy = panels.size * panel_height
    @speed = 0
    @phase = :stop
  end  
  #--------------------------------------------------------------------------
  # ● パネル配列の初期化
  #--------------------------------------------------------------------------
  def init_panels
    unless $game_party.in_battle
      @panels = NWConst::Slot::PANELS[@index]
    else
      @panels  = []
      @panels += [0] * 4
      @panels += [1] * 4
      @panels += [2] * 3
      @panels += [3] * 3
      @panels += [4] * 2
      @panels += [5] * 2
      @panels.shuffle!    
    end
  end  
  #--------------------------------------------------------------------------
  # ● チャンスの初期化
  #--------------------------------------------------------------------------
  def init_chance
    @chance = rand(1 + $game_party.slot_chance)
  end
  #--------------------------------------------------------------------------
  # ● X座標の取得
  #--------------------------------------------------------------------------
  def x
    return @slot.x + NWConst::Slot::REEL_OFFSET[:x] + (panel_width * @index)
  end
  #--------------------------------------------------------------------------
  # ● Y座標の取得
  #--------------------------------------------------------------------------
  def y
    return @slot.y + NWConst::Slot::REEL_OFFSET[:y]
  end
  #--------------------------------------------------------------------------
  # ● Z座標の取得
  #--------------------------------------------------------------------------
  def z
    return @slot.z + 10
  end  
  #--------------------------------------------------------------------------
  # ● パネルの幅取得
  #--------------------------------------------------------------------------
  def panel_width
    return 64
  end
  #--------------------------------------------------------------------------
  # ● パネルの高さ取得
  #--------------------------------------------------------------------------
  def panel_height
    return 64
  end
  #--------------------------------------------------------------------------
  # ● 回転速度の取得
  #--------------------------------------------------------------------------
  def speed
    return 16
  end
  #--------------------------------------------------------------------------
  # ● 滑る確率の取得
  #--------------------------------------------------------------------------
  def miss
    return 0.2
  end
  #--------------------------------------------------------------------------
  # ● 可視範囲
  #--------------------------------------------------------------------------
  def visible_range
    return 3
  end
  #--------------------------------------------------------------------------
  # ● 可視パネル配列の取得
  #--------------------------------------------------------------------------
  def visible_panels
    return panels[(panels.size - visible_range)..-1] + panels
  end  
  #--------------------------------------------------------------------------
  # ● 現在のパネル
  #--------------------------------------------------------------------------
  def current_panels
    return visible_panels[@oy / panel_height, visible_range]
  end
  #--------------------------------------------------------------------------
  # ● 最後のリール？
  #--------------------------------------------------------------------------
  def last_reel?
    return @index == 2
  end
  #--------------------------------------------------------------------------
  # ● 回転の開始
  #--------------------------------------------------------------------------
  def rolling_start
    init_chance
    @phase = :roll
  end
  #--------------------------------------------------------------------------
  # ● 回転の停止
  #--------------------------------------------------------------------------
  def rolling_brake
    @phase = :brake
  end
  #--------------------------------------------------------------------------
  # ● 回転中？
  #--------------------------------------------------------------------------
  def rolling?
    return @phase != :stop
  end  
  #--------------------------------------------------------------------------
  # ● 制動中？
  #--------------------------------------------------------------------------
  def braking?
    return @phase == :brake
  end  
  #--------------------------------------------------------------------------
  # ● ぴったりの位置？
  #--------------------------------------------------------------------------
  def just_position?
    return (@oy % panel_height) == 0
  end    
  #--------------------------------------------------------------------------
  # ● 更新処理
  #--------------------------------------------------------------------------
  def update
    update_phase
    update_speed
    update_rolling   
  end
  #--------------------------------------------------------------------------
  # ● フェイズの更新
  #--------------------------------------------------------------------------
  def update_phase
    return unless (@phase == :brake) && just_position?
    return if rand < miss
    if last_reel? && !@slot.any_bonus? && 0 < @chance
      @chance -= 1
      return
    end
    @phase = :stop
  end
  #--------------------------------------------------------------------------
  # ● 回転速度の更新
  #--------------------------------------------------------------------------
  def update_speed
    @speed = (@phase != :stop) ? speed : 0
  end
  #--------------------------------------------------------------------------
  # ● 回転の更新
  #--------------------------------------------------------------------------
  def update_rolling
    @oy -= @speed
    @oy += panels.size * panel_height
    @oy %= panels.size * panel_height
  end
end

#==============================================================================
# ■ ReelLamp
#==============================================================================
class ReelLamp
  #--------------------------------------------------------------------------
  # ● 公開インスタンス変数
  #--------------------------------------------------------------------------
  attr_reader   :index
  #--------------------------------------------------------------------------
  # ● オブジェクト初期化
  #--------------------------------------------------------------------------
  def initialize(index, slot)
    @index = index
    @slot  = slot
  end  
  #--------------------------------------------------------------------------
  # ● X座標の取得
  #--------------------------------------------------------------------------
  def x
    return @slot.x + NWConst::Slot::REEL_LAMP_OFFSET[index][:x]
  end
  #--------------------------------------------------------------------------
  # ● Y座標の取得
  #--------------------------------------------------------------------------
  def y
    return @slot.y + NWConst::Slot::REEL_LAMP_OFFSET[index][:y]
  end
  #--------------------------------------------------------------------------
  # ● Z座標の取得
  #--------------------------------------------------------------------------
  def z
    return @slot.z + 30
  end
  #--------------------------------------------------------------------------
  # ● 幅取得
  #--------------------------------------------------------------------------
  def width
    return 64
  end
  #--------------------------------------------------------------------------
  # ● 高さ取得
  #--------------------------------------------------------------------------
  def height
    return 64
  end
  #--------------------------------------------------------------------------
  # ● 点灯してる？
  #--------------------------------------------------------------------------
  def lighting?
    return @slot.reels[index].rolling?
  end  
end

#==============================================================================
# ■ LineNumber
#==============================================================================
class LineNumber
  #--------------------------------------------------------------------------
  # ● 公開インスタンス変数
  #--------------------------------------------------------------------------
  attr_reader   :index
  #--------------------------------------------------------------------------
  # ● オブジェクト初期化
  #--------------------------------------------------------------------------
  def initialize(index, slot)
    @index = index
    @slot  = slot
  end
  #--------------------------------------------------------------------------
  # ● X座標の取得
  #--------------------------------------------------------------------------
  def x
    return @slot.x + NWConst::Slot::LINE_NUMBER_OFFSET[index][:x]
  end
  #--------------------------------------------------------------------------
  # ● Y座標の取得
  #--------------------------------------------------------------------------
  def y
    return @slot.y + NWConst::Slot::LINE_NUMBER_OFFSET[index][:y]
  end
  #--------------------------------------------------------------------------
  # ● Z座標の取得
  #--------------------------------------------------------------------------
  def z
    return @slot.z + 30
  end  
  #--------------------------------------------------------------------------
  # ● 幅取得
  #--------------------------------------------------------------------------
  def width
    return 64
  end
  #--------------------------------------------------------------------------
  # ● 高さ取得
  #--------------------------------------------------------------------------
  def height
    return 64
  end
  #--------------------------------------------------------------------------
  # ● 点灯してる？
  #--------------------------------------------------------------------------
  def lighting?
    return @index < CasinoManager.bet_num
  end
end

#==============================================================================
# ■ Game_Slot
#==============================================================================
class Game_Slot
  #--------------------------------------------------------------------------
  # ● 公開インスタンス変数
  #--------------------------------------------------------------------------
  attr_reader   :x
  attr_reader   :y
  attr_reader   :z
  attr_reader   :reels  
  attr_reader   :reel_lamps
  attr_reader   :line_numbers
  attr_reader   :result_bonus
  #--------------------------------------------------------------------------
  # ● オブジェクト初期化
  #--------------------------------------------------------------------------
  def initialize
    @reels = (0...3).collect{|i| Reel.new(i, self)}
    @reel_lamps = (0...3).collect{|i| ReelLamp.new(i, self)}
    @line_numbers = (0...5).collect{|i| LineNumber.new(i, self)}
    clear
  end
  #--------------------------------------------------------------------------
  # ● クリア
  #--------------------------------------------------------------------------
  def clear
    @x = $game_party.in_battle ? 160 : 40
    @y = 0
    @z = 151
    @now_time = Time.now.to_f
    @current_index = 0
    reels.each{|reel| reel.clear}
    clear_result
  end
  #--------------------------------------------------------------------------
  # ● 結果のクリア
  #--------------------------------------------------------------------------
  def clear_result
    @result_bonus = nil
  end
  #--------------------------------------------------------------------------
  # ● 結果【説明】の取得
  #--------------------------------------------------------------------------
  def result_desc
    return @result_bonus ? NWConst::Slot::BONUS[@result_bonus][:desc] : ""
  end
  #--------------------------------------------------------------------------
  # ● 結果【倍率】の取得
  #--------------------------------------------------------------------------
  def result_scale
    return @result_bonus ? NWConst::Slot::BONUS[@result_bonus][:scale] : 0
  end
  #--------------------------------------------------------------------------
  # ● 結果【スキルID】の取得
  #--------------------------------------------------------------------------
  def result_skill_id
    return @result_bonus ? NWConst::Slot::BONUS[@result_bonus][:skill_id] : 0
  end  
  #--------------------------------------------------------------------------
  # ● 結果【効果音】の取得
  #--------------------------------------------------------------------------
  def result_sound
    return @result_bonus ? NWConst::Slot::BONUS[@result_bonus][:sound] : nil
  end
  #--------------------------------------------------------------------------
  # ● 結果【メダル】の取得
  #--------------------------------------------------------------------------
  def result_medal
    return @result_bonus ? NWConst::Slot::BONUS[@result_bonus][:medal] : nil
  end
  #--------------------------------------------------------------------------
  # ● バック部分Z座標
  #--------------------------------------------------------------------------
  def back_z
    return z
  end
  #--------------------------------------------------------------------------
  # ● フロント部分Z座標
  #--------------------------------------------------------------------------
  def front_z
    return z + 20
  end
  #--------------------------------------------------------------------------
  # ● 現在選択中のリール
  #--------------------------------------------------------------------------
  def current_reel
    return reels[@current_index]
  end
  #--------------------------------------------------------------------------
  # ● 停止中？
  #--------------------------------------------------------------------------
  def stand?
    return reels.all?{|reel| !reel.rolling?}
  end  
  #--------------------------------------------------------------------------
  # ● 回転中？
  #--------------------------------------------------------------------------
  def rolling?
    return reels.any?{|reel| reel.rolling?}
  end  
  #--------------------------------------------------------------------------
  # ● 更新処理
  #--------------------------------------------------------------------------
  def update
    update_reel
    update_time
    update_index
  end
  #--------------------------------------------------------------------------
  # ● リールの更新
  #--------------------------------------------------------------------------
  def update_reel
    reels.each{|reel| reel.update}
  end
  #--------------------------------------------------------------------------
  # ● 回転開始
  #--------------------------------------------------------------------------
  def rolling_start
    reels.each{|reel| reel.rolling_start}
    @current_index = 0
    NWConst::Slot::START_SE.play
  end
  #--------------------------------------------------------------------------
  # ● 回転停止
  #--------------------------------------------------------------------------
  def rolling_stop
    return unless @current_index < reels.size
    return if current_reel.braking?
    current_reel.rolling_brake
    NWConst::Slot::STOP_SE.play
  end  
  #--------------------------------------------------------------------------
  # ● 現在時間の更新
  #--------------------------------------------------------------------------
  def update_time
    goof_check
    @now_time = Time.now.to_f
  end
  #--------------------------------------------------------------------------
  # ● イカサマチェック
  #--------------------------------------------------------------------------
  def goof_check
    return unless 0.5 < (Time.now.to_f - @now_time)
    return unless rolling?
    rolling_stop
  end
  #--------------------------------------------------------------------------
  # ● 選択リールの更新
  #--------------------------------------------------------------------------
  def update_index
    return if stand?
    return unless @current_index < reels.size
    return if current_reel.rolling?
    @current_index += 1
  end
  #--------------------------------------------------------------------------
  # ● ボーナスの判定
  #--------------------------------------------------------------------------
  def check_bonus(line_data)
    line = []
    line_data.each_with_index{|pi, i| line.push(reels[i].current_panels[pi])}
    NWConst::Slot::BONUS.keys.reverse_each{|bonus|
      next unless hit_bonus?(line, bonus)
      @result_bonus = bonus
      break
    }
  end
  #--------------------------------------------------------------------------
  # ● 役に等しい？
  #--------------------------------------------------------------------------
  def hit_bonus?(line, bonus)
    eval = []
    bonus.each_with_index{|p, i| eval.push(p != -1 ? p : line[i])}
    return eval == line
  end
  #--------------------------------------------------------------------------
  # ● どれか一つでも当たり役がある？
  #--------------------------------------------------------------------------
  def any_bonus?
    lines = NWConst::Slot::LINES[0, CasinoManager.bet_num]
    lines.each{|line_data|
      line = []
      line_data.each_with_index{|pi, i| line.push(reels[i].current_panels[pi])}
      NWConst::Slot::BONUS.keys.reject{|bonus|
        bonus.any?{|b| b == -1}
      }.each{|bonus|
        next unless hit_bonus?(line, bonus)
        return true
      }
    }
    return false
  end
end

#==============================================================================
# ■ Sprite_Reel
#==============================================================================
class Sprite_Reel < Sprite
  #--------------------------------------------------------------------------
  # ● オブジェクト初期化
  #--------------------------------------------------------------------------
  def initialize(reel)
    @reel = reel
    super()
    create_bitmap
    self.x = @reel.x
    self.y = @reel.y
    self.z = @reel.z
  end
  #--------------------------------------------------------------------------
  # ● ビットマップの生成
  #--------------------------------------------------------------------------
  def create_bitmap
    src_bitmap = Cache.casino("slot_panels")
    dst_bitmap = Bitmap.new(@reel.panel_width, @reel.panel_height * @reel.visible_panels.size)
    src_rect = Rect.new(0, 0, @reel.panel_width, @reel.panel_height)
    dst_rect = Rect.new(0, 0, @reel.panel_width, @reel.panel_height)
    
    @reel.visible_panels.each_with_index{|panel, i|
      src_rect.x = (panel % 4) * @reel.panel_width
      src_rect.y = (panel / 4) * @reel.panel_height
      dst_rect.y = i * @reel.panel_height
      dst_bitmap.stretch_blt(dst_rect, src_bitmap, src_rect) 
    }
    src_bitmap.dispose
    self.bitmap = dst_bitmap
    self.src_rect.set(0, @reel.oy, @reel.panel_width, @reel.panel_height * @reel.visible_range)
  end
  #--------------------------------------------------------------------------
  # ● 解放
  #--------------------------------------------------------------------------
  def dispose
    self.bitmap.dispose
    super
  end
  #--------------------------------------------------------------------------
  # ● 更新処理
  #--------------------------------------------------------------------------
  def update
    super
    self.src_rect.y = @reel.oy
  end
end

#==============================================================================
# ■ Sprite_ReelLamp
#==============================================================================
class Sprite_ReelLamp < Sprite
  #--------------------------------------------------------------------------
  # ● オブジェクト初期化
  #--------------------------------------------------------------------------
  def initialize(reel_lamp)
    @reel_lamp = reel_lamp
    super()
    create_bitmap
    self.x = @reel_lamp.x
    self.y = @reel_lamp.y
    self.z = @reel_lamp.z
  end
  #--------------------------------------------------------------------------
  # ● ビットマップの生成
  #--------------------------------------------------------------------------
  def create_bitmap
    self.bitmap = Cache.casino("slot_reel_lamp")
    self.src_rect.set(0, 0, @reel_lamp.width, @reel_lamp.height)
  end
  #--------------------------------------------------------------------------
  # ● 解放
  #--------------------------------------------------------------------------
  def dispose
    self.bitmap.dispose
    super
  end  
  #--------------------------------------------------------------------------
  # ● 更新処理
  #--------------------------------------------------------------------------
  def update
    super
    self.src_rect.y = @reel_lamp.lighting? ? @reel_lamp.height : 0
  end
end

#==============================================================================
# ■ Sprite_LineNumber
#==============================================================================
class Sprite_LineNumber < Sprite
  #--------------------------------------------------------------------------
  # ● オブジェクト初期化
  #--------------------------------------------------------------------------
  def initialize(line_number)
    @line_number = line_number
    super()
    create_bitmap
    self.x = @line_number.x
    self.y = @line_number.y
    self.z = @line_number.z
  end
  #--------------------------------------------------------------------------
  # ● ビットマップの生成
  #--------------------------------------------------------------------------
  def create_bitmap
    self.bitmap = Cache.casino("slot_line_number")
    x = @line_number.index * @line_number.width
    self.src_rect.set(x, 0, @line_number.width, @line_number.height)
  end
  #--------------------------------------------------------------------------
  # ● 解放
  #--------------------------------------------------------------------------
  def dispose
    self.bitmap.dispose
    super
  end  
  #--------------------------------------------------------------------------
  # ● 更新処理
  #--------------------------------------------------------------------------
  def update
    super
    self.src_rect.y = @line_number.lighting? ? @line_number.height : 0
  end
end

#==============================================================================
# ■ Spriteset_Slot
#==============================================================================
class Spriteset_Slot
  #--------------------------------------------------------------------------
  # ● オブジェクト初期化
  #--------------------------------------------------------------------------
  def initialize
    create_back_sprite
    create_reel_sprites
    create_front_sprite
    create_reel_lamp_sprites    
    create_line_number_sprites
  end
  #--------------------------------------------------------------------------
  # ● 背面スプライトの生成
  #--------------------------------------------------------------------------
  def create_back_sprite
    @back_sprite = Sprite.new
    @back_sprite.bitmap = Cache.casino("slot_bg")
    @back_sprite.x = $game_slot.x
    @back_sprite.y = $game_slot.y
    @back_sprite.z = $game_slot.back_z
  end
  #--------------------------------------------------------------------------
  # ● リールスプライトの生成
  #--------------------------------------------------------------------------
  def create_reel_sprites
    @reel_sprites = []
    $game_slot.reels.each{|reel| @reel_sprites.push(Sprite_Reel.new(reel))}
  end
  #--------------------------------------------------------------------------
  # ● 前面スプライトの生成
  #--------------------------------------------------------------------------
  def create_front_sprite
    @front_sprite = Sprite.new
    @front_sprite.bitmap = Cache.casino("slot_fg")
    @front_sprite.x = $game_slot.x
    @front_sprite.y = $game_slot.y
    @front_sprite.z = $game_slot.front_z
  end
  #--------------------------------------------------------------------------
  # ● リールランプスプライトの生成
  #--------------------------------------------------------------------------
  def create_reel_lamp_sprites
    @reel_lamp_sprites = []
    $game_slot.reel_lamps.each{|reel_lamp|
      @reel_lamp_sprites.push(Sprite_ReelLamp.new(reel_lamp))
    }
  end  
  #--------------------------------------------------------------------------
  # ● ライン番号スプライトの生成
  #--------------------------------------------------------------------------
  def create_line_number_sprites
    @line_number_sprites = []
    $game_slot.line_numbers.each{|line_number|
      @line_number_sprites.push(Sprite_LineNumber.new(line_number))
    }
  end  
  #--------------------------------------------------------------------------
  # ● 解放
  #--------------------------------------------------------------------------
  def dispose
    dispose_back_sprite
    dispose_reel_sprites
    dispose_front_sprite
    dispose_reel_lamp_sprites
    dispose_line_number_sprites
  end
  #--------------------------------------------------------------------------
  # ● 背面スプライトの解放
  #--------------------------------------------------------------------------
  def dispose_back_sprite
    @back_sprite.bitmap.dispose
    @back_sprite.dispose
  end  
  #--------------------------------------------------------------------------
  # ● リールスプライトの解放
  #--------------------------------------------------------------------------
  def dispose_reel_sprites
    @reel_sprites.each{|sprite| sprite.dispose}
  end
  #--------------------------------------------------------------------------
  # ● 前面スプライトの解放
  #--------------------------------------------------------------------------
  def dispose_front_sprite
    @front_sprite.bitmap.dispose
    @front_sprite.dispose
  end  
  #--------------------------------------------------------------------------
  # ● リールランプスプライトの解放
  #--------------------------------------------------------------------------
  def dispose_reel_lamp_sprites
    @reel_lamp_sprites.each{|sprite| sprite.dispose}
  end
  #--------------------------------------------------------------------------
  # ● ライン番号スプライトの解放
  #--------------------------------------------------------------------------
  def dispose_line_number_sprites
    @line_number_sprites.each{|sprite| sprite.dispose}
  end
  #--------------------------------------------------------------------------
  # ● 更新処理
  #--------------------------------------------------------------------------
  def update
    update_reel_sprites
    update_reel_lamp_sprites
    update_line_number_sprites
  end
  #--------------------------------------------------------------------------
  # ● リールスプライトの更新
  #--------------------------------------------------------------------------
  def update_reel_sprites
    @reel_sprites.each{|sprite| sprite.update}
  end
  #--------------------------------------------------------------------------
  # ● リールランプスプライトの更新
  #--------------------------------------------------------------------------
  def update_reel_lamp_sprites
    @reel_lamp_sprites.each{|sprite| sprite.update}
  end
  #--------------------------------------------------------------------------
  # ● ライン番号スプライトの更新
  #--------------------------------------------------------------------------
  def update_line_number_sprites
    @line_number_sprites.each{|sprite| sprite.update}
  end
  #--------------------------------------------------------------------------
  # ● ライン番号スプライトの強調
  #--------------------------------------------------------------------------
  def set_line_number(index)
    color1 = Color.new(255, 255, 255, 128)
    color2 = Color.new(0, 0, 0, 0)
    @line_number_sprites.each_with_index do |sprite, i|
      sprite.color = index.include?(i) ? color1 : color2
    end
  end
end

#==============================================================================
# ■ Window_SlotBonus
#==============================================================================
class Window_SlotBonus < Window_Base
  #--------------------------------------------------------------------------
  # ● オブジェクト初期化
  #--------------------------------------------------------------------------
  def initialize
    super(Graphics.width - window_width, 0, window_width, window_height)
    self.contents.font.name =  ["ＭＳ ゴシック"]
    @cursor_keys = []
    make_list
    refresh
    make_show_windows
  end
  #--------------------------------------------------------------------------
  # ● ウィンドウ幅の取得
  #--------------------------------------------------------------------------
  def window_width
    240
  end
  #--------------------------------------------------------------------------
  # ● ウィンドウ高さの取得
  #--------------------------------------------------------------------------
  def window_height
    fitting_height(8) + 1
  end
  #--------------------------------------------------------------------------
  # ● 行の高さを取得
  #--------------------------------------------------------------------------
  def line_height
    return 36
  end
  #--------------------------------------------------------------------------
  # ● リスト内容の生成
  #--------------------------------------------------------------------------
  def make_list
    @list = NWConst::Slot::BONUS.clone
    @list.delete([-1, -1, -1])
  end
  #--------------------------------------------------------------------------
  # ● リフレッシュ
  #--------------------------------------------------------------------------
  def refresh
    contents.clear
    draw_bonus
  end
  #--------------------------------------------------------------------------
  # ● 子ウインドウの作成
  #--------------------------------------------------------------------------
  def make_show_windows
    @show_windows = []
    @list.keys.each do |key|
      @show_windows.push(Window_SlotBonusShow.new(key, self))
    end
  end
  #--------------------------------------------------------------------------
  # ● 役の描画
  #--------------------------------------------------------------------------
  def draw_bonus
    change_color(normal_color)
    bitmap = Cache.casino("slot_panels")
    @list.reverse_each do |key, value|
      rect = rect_bonus(key)
      draw_bonus_panels(rect, key, bitmap)
      draw_bonus_scale(rect, value[:scale])
      if key[0] == 0 and @cursor_keys.count(key) >= 1
        rect.x += 100
        draw_text(rect, sprintf("×%d", @cursor_keys.count(key)))
      end
    end
    bitmap.dispose
  end
  #--------------------------------------------------------------------------
  # ● 役パネルの描画
  #--------------------------------------------------------------------------
  def draw_bonus_panels(rect, key, bitmap)
    key.each_with_index{|panel, i|
      next if panel < 0
      dst_rect = Rect.new(rect.x + 32 * i, rect.y, 32, 32)
      src_rect = Rect.new(64 * (panel % 4), 64 * (panel / 4), 64, 64)
      contents.stretch_blt(dst_rect, bitmap, src_rect) 
    }
  end
  #--------------------------------------------------------------------------
  # ● 役取得コインの描画
  #--------------------------------------------------------------------------
  def draw_bonus_scale(rect, scale)
    dst_rect = Rect.new(rect.x, rect.y + 3, rect.width - 6, contents.font.size)
    draw_text(dst_rect, CasinoManager.minimum_coin * scale, 2)
  end
  #--------------------------------------------------------------------------
  # ● カーソルの矩形
  #--------------------------------------------------------------------------
  def rect_cursor(key)
    rect = Rect.new(0, 0, contents.width, line_height + 1)
    rect.y = @list.keys.reverse.index(key) * line_height
    return rect
  end
  #--------------------------------------------------------------------------
  # ● 役描画用の矩形
  #--------------------------------------------------------------------------
  def rect_bonus(key)
    rect = rect_cursor(key)
    rect.x += 2
    rect.y += 2
    return rect
  end
  #--------------------------------------------------------------------------
  # ● 更新処理
  #--------------------------------------------------------------------------
  def update
    super
    @show_windows.each {|w| w.update }
  end
  #--------------------------------------------------------------------------
  # ● 解放
  #--------------------------------------------------------------------------
  def dispose
    super
    @show_windows.each {|w| w.dispose }
  end
  #--------------------------------------------------------------------------
  # ● カーソル位置キー取得
  #--------------------------------------------------------------------------
  def cursor_keys
    @cursor_keys
  end
  #--------------------------------------------------------------------------
  # ● カーソル位置キー設定とリフレッシュ
  #--------------------------------------------------------------------------
  def cursor_keys=(k)
    @cursor_keys = k
    refresh
  end
end

#==============================================================================
# ■ Window_SlotBonusShow
#==============================================================================
class Window_SlotBonusShow < Window_SlotBonus
  #--------------------------------------------------------------------------
  # ● オブジェクト初期化
  #-------------------------------------------------------------------------
  def initialize(key, base)
    @base_window = base
    super()
    self.z = base.z + 1
    self.opacity = 0
    @key = key
  end
  #--------------------------------------------------------------------------
  # ● ウィンドウ幅の取得
  #--------------------------------------------------------------------------
  def window_width
    return @base_window.width
  end
  #--------------------------------------------------------------------------
  # ● 子ウインドウの作成
  #--------------------------------------------------------------------------
  def make_show_windows
    @show_windows = []
  end
  #--------------------------------------------------------------------------
  # ● 更新処理
  #--------------------------------------------------------------------------
  def update
    super
    if @base_window.cursor_keys.include?(@key)
      self.cursor_rect.set(rect_cursor(@key))
    else
      self.cursor_rect.empty
    end
  end
  #--------------------------------------------------------------------------
  # ● リフレッシュ
  #--------------------------------------------------------------------------
  def refresh
    contents.clear
  end
end

#==============================================================================
# ■ Scene_Slot
#==============================================================================
class Scene_Slot < Scene_CasinoBase
  #--------------------------------------------------------------------------
  # ● 開始処理
  #--------------------------------------------------------------------------
  def start
    super
    $game_slot.clear
    create_spriteset
    @desc_window.set_text(Help.slot_description[:stand])
  end
  #--------------------------------------------------------------------------
  # ● 終了処理
  #--------------------------------------------------------------------------
  def terminate
    super
    dispose_spriteset
  end
  #--------------------------------------------------------------------------
  # ● スプライトセットの作成
  #--------------------------------------------------------------------------
  def create_spriteset
    @spriteset = Spriteset_Slot.new
  end
  #--------------------------------------------------------------------------
  # ● 全ウィンドウの作成
  #--------------------------------------------------------------------------
  def create_all_window
    super
    create_bonus_window
  end  
  #--------------------------------------------------------------------------
  # ● 役ウィンドウの作成
  #--------------------------------------------------------------------------
  def create_bonus_window
    @bonus_window = Window_SlotBonus.new
  end  
  #--------------------------------------------------------------------------
  # ● スプライトセットの解放
  #--------------------------------------------------------------------------
  def dispose_spriteset
    @spriteset.dispose
  end  
  #--------------------------------------------------------------------------
  # ● フレーム更新
  #--------------------------------------------------------------------------
  def update
    super
    $game_slot.update
    @spriteset.update
  end
  #--------------------------------------------------------------------------
  # ● 待機時の更新処理
  #--------------------------------------------------------------------------
  def update_stand
    super
    if Input.trigger?(:C)
      unless (0 == CasinoManager.bet_coin) || CasinoManager.over_bet?
        $game_party.lose_coin(CasinoManager.bet_coin)
        $game_slot.rolling_start
        change_phase(:play)
        @desc_window.set_text(Help.slot_description[:play])
      else
        Sound.play_buzzer
      end
    end
  end
  #--------------------------------------------------------------------------
  # ● ゲーム中の更新処理
  #--------------------------------------------------------------------------
  def update_play
    super
    $game_slot.rolling_stop if Input.trigger?(:C)
    process_result unless $game_slot.rolling?
  end
  #--------------------------------------------------------------------------
  # ● 結果処理
  #--------------------------------------------------------------------------
  def process_result
    CasinoManager.slot_result.each do |bonus_lines|
      gain_coin = 0
      desc_text = nil
      sound = nil
      bonuses = []
      bonus_lines.each do |line_index|
        $game_slot.check_bonus(NWConst::Slot::LINES[line_index])
        CasinoManager.process_medal(:slot, $game_slot.result_medal, 0)
        bonuses.push($game_slot.result_bonus)
        gain_coin += CasinoManager.minimum_coin * $game_slot.result_scale
        desc_text = $game_slot.result_desc
        sound = $game_slot.result_sound
      end
      @spriteset.set_line_number(bonus_lines)
      @bonus_window.cursor_keys = bonuses
      $game_party.gain_coin(gain_coin)
      @desc_window.set_text(desc_text + "\n#{gain_coin} coins won!")
      CasinoManager.process_sound(:slot, sound, method(:abs_wait))
      @bonus_window.cursor_keys = []
    end
    
    @spriteset.set_line_number([])
    $game_slot.clear_result
    @desc_window.set_text(Help.slot_description[:stand])
    change_phase(:stand)
  end
end

#==============================================================================
# ■ Scene_Battle
#==============================================================================
class Scene_Battle < Scene_Base
  #--------------------------------------------------------------------------
  # ● スロットの処理
  #--------------------------------------------------------------------------
  def process_slot
    $game_slot.clear
    CasinoManager.setup(0)
    CasinoManager.add_line
    slot_spriteset = Spriteset_Slot.new
    @battleslot_bonus_window = Window_BattleSlotBonus.new
    
    $game_slot.rolling_start
    while $game_slot.rolling?
      update_basic
      $game_slot.update
      $game_slot.rolling_stop if Input.trigger?(:C)
      slot_spriteset.update
    end
    
    abs_wait(6)
    result_skill_id = 1
    sound = NWConst::Casino::SE_LOSE
    
    CasinoManager.bet_num.times do |i|
      $game_slot.check_bonus(NWConst::Slot::LINES[i])
      if result_skill_id < $game_slot.result_skill_id
        sound = $game_slot.result_sound
        result_skill_id = $game_slot.result_skill_id
        @battleslot_bonus_window.select_key = $game_slot.result_bonus
        slot_spriteset.set_line_number([i]) if $game_slot.result_bonus[0] >= 0
      end
      CasinoManager.process_medal(:slot, $game_slot.result_medal, 1)
    end
    CasinoManager.process_sound(:slot, sound, method(:abs_wait))
    
    slot_spriteset.dispose
    @battleslot_bonus_window.dispose
    remove_instance_variable(:@battleslot_bonus_window)
    
    return result_skill_id
  end
end
#==============================================================================
# ■ Window_BattleSlotBonus
#==============================================================================
class Window_BattleSlotBonus < Window_SlotBonus
  #--------------------------------------------------------------------------
  # ● ウィンドウ幅の取得
  #--------------------------------------------------------------------------
  def window_width
    120
  end
  #--------------------------------------------------------------------------
  # ● 役取得コインの描画
  #--------------------------------------------------------------------------
  def draw_bonus_scale(rect, scale)
    return
  end
  #--------------------------------------------------------------------------
  # ● カーソル位置のキーを設定
  #--------------------------------------------------------------------------
  def select_key=(key)
    return unless @list.keys.include?(key)
    @select_key = key
  end
  #--------------------------------------------------------------------------
  # ● カーソル位置のキー
  #--------------------------------------------------------------------------
  def cursor_keys
    [@select_key]
  end
end